import { system, world } from "@minecraft/server";
import { Database } from "./Database/Database";
import { getDatabaseDataInitial, loadHumanObjects, loadPlayerData, registerCommands, saveDatabaseDataTerminal } from "./Infrastructure/Registration";
import { CommandJ } from "./Database/Command";
import { ModalFormData } from "@minecraft/server-ui";
import { Human } from "./Game/Structure/Human";
import { runConstant, report } from "./Infrastructure/ConstantLoader";


export let db = new Database("global");
// Initial runs
world.afterEvents.worldInitialize.subscribe((ev)=>{
    db.newTable("userData");
    db.newKeyInTable("userData", "players", ["0"]);
    db.newKeyInTable("userData", "humanObjects", [new Human("Monika", "Monika", Date(), "nope")]);
    db.newTable("schools");
    db.newKeyInTable("schools", "schoolDatas", []);
    system.runTimeout(()=>{runConstant()}, 1);
    system.runTimeout(()=>{report(db.getSaveString());getDatabaseDataInitial(); loadHumanObjects()}, 5);
    system.runTimeout(()=>{loadPlayerData(); saveDatabaseDataTerminal(), registerCommands()}, 10);
});

// Checks for the '-run' command
world.beforeEvents.chatSend.subscribe((ev)=>{
    if(ev.message.startsWith("-run ")){
        ev.cancel = true;
        system.run(()=>{ev.sender.runCommand("scriptevent "+ev.message.split(" ")[1]+" run");});
        return;
    };
});

// Activates the '-run' command. Players can use it to run registered custom commands (CommandJ)
system.afterEvents.scriptEventReceive.subscribe((event)=>{
    if(event.message == "run"){
        for(let i = 0; i<CommandJ.storage.length; i++){
            if(CommandJ.storage[i].id==event.id){
                /* create an entry for every argument*/
                let args = [];
                let f = new ModalFormData();
                f.title("Args"); 
                for(let a = 0; a < CommandJ.storage[i].args.length; a++){
                    f.textField(CommandJ.storage[i].args[a], "Enter here!");
                };
                /* get argument values and run command*/
                system.runTimeout(()=>{
                    if(CommandJ.storage[i].args.length <1){
                        CommandJ.storage[i].run(event.sourceEntity, "", event, args);
                        return;
                    }else{ 
                        f.show(event.sourceEntity).then((r)=>{
                            if(r.canceled){return;} 
                            args = r.formValues;
                            CommandJ.storage[i].run(event.sourceEntity, "", event, args)
                            return;
                        })}
                }, 20)
            }
        };
    }
});